library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.SHA256_PACKAGE.all;

entity S3_BLOCK is
	port( X : in std_logic_vector(31 downto 0);
		  O : out std_logic_vector(31 downto 0));
end S3_BLOCK;

architecture BEHAVIORAL of S3_BLOCK is

	signal ROR6 : std_logic_vector(31 downto 0);
	signal ROR11 : std_logic_vector(31 downto 0);
	signal ROR25 : std_logic_vector(31 downto 0);

begin

	ROR6 <= X(5 downto 0) & X(31 downto 6);
	ROR11 <= X(10 downto 0) & X(31 downto 11);
	ROR25 <= X(24 downto 0) & X(31 downto 25);

	O <= ROR6 xor ROR11 xor ROR25;

end BEHAVIORAL;